(**************************************************************************)
(*                                BELENIOS                                *)
(*                                                                        *)
(*  Copyright © 2012-2021 Inria                                           *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU Affero General Public License as        *)
(*  published by the Free Software Foundation, either version 3 of the    *)
(*  License, or (at your option) any later version, with the additional   *)
(*  exemption that compiling, linking, and/or using OpenSSL is allowed.   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  Affero General Public License for more details.                       *)
(*                                                                        *)
(*  You should have received a copy of the GNU Affero General Public      *)
(*  License along with this program.  If not, see                         *)
(*  <http://www.gnu.org/licenses/>.                                       *)
(**************************************************************************)

type datetime
val now : unit -> datetime
val raw_string_of_datetime : datetime -> string
val raw_datetime_of_string : string -> datetime
val datetime_compare : datetime -> datetime -> int
val format_datetime : ?fmt:string -> datetime -> string
val unixfloat_of_datetime : datetime -> float
val datetime_of_unixfloat : float -> datetime

type period
val day : int -> period
val second : int -> period
val datetime_add : datetime -> period -> datetime
val datetime_sub : datetime -> datetime -> period
val ymds : period -> int * int * int * int

type 'a user_or_id =
  [ `Id of int list
  | `User of 'a
  ]
